--EXECUTE P_DW_PRODUTOS_FALTA_GRUPO_PRODUTOS_FILIAL_FILIAL 1,NULL,2
ALTER PROCEDURE [dbo].[P_DW_PRODUTOS_FALTA_GRUPO_PRODUTOS_FILIAL_FILIAL] (@CD_EMP INT = 1, @DT_INI DATETIME = NULL, @CD_FILIAL INT) AS
	SET NOCOUNT ON
	IF @DT_INI IS NULL
	BEGIN
		SET @DT_INI=DBO.F_ONTEM(); 
	END 
	DECLARE @TIPO_ANALISE_FALTAS INT
	
	DECLARE @CD_FILIAL_DEPO INT, 
			@CD_CTR_DEPO INT, 
			@VL_TOT_LJ FLOAT, 
			@QT_TOT_LJ FLOAT, 
			@VL_TOT_RD FLOAT, 
			@QT_TOT_RD FLOAT ;
SET @TIPO_ANALISE_FALTAS=ISNULL((SELECT 
									VALOR AS ORC_PED_CP
								 FROM 
									PRC_EMP_CONFIG
								 WHERE 
									CD_EMP	= @CD_EMP 
								    AND	CD_CHAVE = 'TIPO_ANALISE_FALTA_PRODUTO'),0);


	SELECT  TOP 1
		@CD_FILIAL_DEPO = CD_FILIAL_DEPO,
		@CD_CTR_DEPO = CD_CTR_DEPO
	FROM 
		V_PRC_FILIAL_DEPOSITO
	WHERE 
		CD_FILIAL = @CD_FILIAL 
		AND CD_EMP = @CD_EMP ; 
		 
	DELETE FROM EST_PROD_CPL_ANALISE_FALTAS_FILIAL 
	WHERE DT_MOV = @DT_INI 
		AND CD_EMP = @CD_EMP 
		AND CD_FILIAL = @CD_FILIAL; 

    --Falta meses fechado
	IF @TIPO_ANALISE_FALTAS= 0 
	 BEGIN		
		 SELECT 
			@VL_TOT_LJ = SUM(VLR_VD_TOTAL)  ,
			@QT_TOT_LJ = SUM(QTDE_TOTAL)	 
		 FROM 
			EST_PROD_CPL_ANALISE
		 WHERE
			CD_EMP=@CD_EMP
			AND CD_FILIAL =@CD_FILIAL
			AND ANO = YEAR(@DT_INI)
			AND MES = MONTH(@DT_INI);
			
		SELECT 
			@VL_TOT_RD = SUM(VLR_VD_TOTAL) ,
			@QT_TOT_RD = SUM(QTDE_TOTAL)	 
		 FROM 
			EST_PROD_CPL_ANALISE
		 WHERE
			CD_EMP=@CD_EMP
			AND CD_FILIAL =@CD_FILIAL_DEPO
			AND ANO = YEAR(@DT_INI)
			AND MES = MONTH(@DT_INI);
	END

    --Falta ultimos 30 dias
	IF @TIPO_ANALISE_FALTAS= 1 
	 BEGIN		
		 SELECT 
			@VL_TOT_LJ = SUM(VLR_VD_TOTAL)  ,
			@QT_TOT_LJ = SUM(QTDE_TOTAL)	 
		 FROM 
			EST_PROD_CPL_ANALISE_30
		 WHERE
			CD_EMP=@CD_EMP
			AND CD_FILIAL =@CD_FILIAL
			AND DT_MOV = @DT_INI;
			
		SELECT 
			@VL_TOT_RD = SUM(VLR_VD_TOTAL) ,
			@QT_TOT_RD = SUM(QTDE_TOTAL)	 
		 FROM 
			EST_PROD_CPL_ANALISE_30
		 WHERE
			CD_EMP=@CD_EMP
			AND DT_MOV = @DT_INI;
	END
	
	PRINT 'Inicio do procedimento - Time: ' + CONVERT(varchar, getdate(),108)
	PRINT 'DATA ' + CONVERT(VARCHAR, @DT_INI,112) + ' - FILIAL ' + CONVERT(VARCHAR, @CD_FILIAL ) + ' - DEPOSITO ' + CONVERT(VARCHAR, @CD_FILIAL_DEPO) + ' - CD_CTR_DEPO ' + CONVERT(VARCHAR, @CD_CTR_DEPO)

	INSERT INTO EST_PROD_CPL_ANALISE_FALTAS_FILIAL
	(DT_MOV,
		CD_FILIAL,
		CD_EMP,
		CD_PROD,
		DS_PROD,
		NM_FABRIC,
		DS_SIGLA,
		DS_ARV_MERC_LINHA,
		TIPO_COMPRA,
		VLR_MEDIO_VD,
		QT_VD_DIA,
		PART_QTDE,
		PART_VLR,
		VLR_PERDA_VD,	
		QTDE_PERDA_VD,	
		MEDIAF, 
		EST_MTZ, 
		EST_PEND_MTZ,
		EST_PEND_LJ, 
		EMAX, 
		EXCESSO, 
		NECESSIDADE,
		CD_SIGLA,
		CD_ARV_MERC_LINHA,
		CD_CTR_DEPO,
		PART_LJ_QTD,
		PART_LJ_VLR,
		CD_CTR_GRP_CP)
	SELECT
		VD_PROD.DT_VD,   	
		VD_PROD.CD_FILIAL,
		CD_EMP = @CD_EMP,
		VD_PROD.CD_PROD,   	
		DS_PROD		= CPL.DS_PROD,
		NM_FABRIC	= CPL.NM_FABRIC,
		DS_SIGLA	= CPL.DS_SIGLA,
		DS_ARV_MERC_LINHA = CPL.DS_ARV_MERC_LINHA,
		TIPO_COMPRA = CPL.TIPO,
		VLR_MEDIO_VD = VD.VLR_MEDIO_VD,
		QT_VD_DIA = VD.QT_VD_DIA,
		PART_QTDE	  = (VD_PROD.PART_QTDE/vd.PART_QTDE_VD)*100.000 ,  
		PART_VLR	  = (VD_PROD.PART_VLR/vd.PART_VLR_VD)*100.0000,
		VLR_PERDA_VD  = ROUND( (VD.VLR_MEDIO_VD * CASE WHEN VD.PART_VLR_VD > 0 THEN
											(VD_PROD.PART_VLR/VD.PART_VLR_VD) ELSE 0 END),6) ,	
																					
		QTDE_PERDA_VD =  ROUND( (VD.QT_VD_DIA * CASE WHEN VD.PART_QTDE_VD > 0 THEN
											(VD_PROD.PART_QTDE/VD.PART_QTDE_VD) ELSE 0 END),6),
						 
		MEDIAF		 = CPL.MEDIAF,
		EST_MTZ		 = CPL.EST_MTZ,
		EST_PEND_MTZ = CPL.QT_PEND_MTZ,
		EST_PEND_LJ  = CPL.QT_PEND_LJ,
		EMAX		 = CPL.EMAX,
		EXCESSO		 = E.EXCESSO,
		NECESSIDADE	 = isnull(CPL.NECESSIDADE,0),
		CD_SIGLA	 = CPL.CD_SIGLA,
		CD_ARV_MERC_LINHA=CPL.CD_ARV_MERC_LINHA,
		@CD_CTR_DEPO,
		@QT_TOT_LJ/@QT_TOT_RD,
		@VL_TOT_LJ/@VL_TOT_RD,
		grplj.CD_CTR 
FROM 
	(SELECT   
		a.CD_FILIAL,
		a.CD_PROD,   
		a.DT_VD,
		SUM(a.PART_QTDE) AS PART_QTDE,   
		SUM(a.PART_VLR) AS PART_VLR
	FROM 
		EST_PROD_CPL_ANALISE_DIARIO a 
	WHERE   
		a.CD_EMP = @CD_EMP
		AND a.DT_VD =  @DT_INI
		AND a.QT_EST < 1
		AND a.STS_PROD_EMP = 0
		AND a.STS_PROD_FILIAL = 0
		AND a.FLAG_ANALISE_FALTAS=0
		AND a.LJ_FLAG_PARTIC_INDIC = 1
		AND a.CD_FILIAL =@CD_FILIAL
	GROUP BY   
		a.CD_FILIAL,
		a.CD_PROD,	 
		a.DT_VD) VD_PROD 
	INNER JOIN (SELECT   		
					a.DT_VD,   
					SUM(a.VLR_MEDIO_VD) AS VLR_MEDIO_VD,   
					SUM(a.QT_VD_DIA)	As QT_VD_DIA,   
					SUM(a.PART_QTDE)	AS PART_QTDE_VD,   
					SUM(a.PART_VLR)		As PART_VLR_VD 
				FROM 
					EST_PROD_CPL_ANALISE_DIARIO a  
				WHERE   
					a.CD_EMP =@CD_EMP
					AND a.DT_VD = @DT_INI
					AND a.CD_FILIAL NOT IN (SELECT CD_FILIAL FROM PRC_FILIAL WHERE FILIAL_MTZ=1 OR FLAG_NAO_PARTIC_INDIC=1)
					
				GROUP BY   
					a.DT_VD) VD ON 		
				VD_PROD.DT_VD = VD.DT_VD  
	
	INNER JOIN(SELECT	
					A.CD_FILIAL,
					A.CD_PROD, 
					P.DS_PROD, 
					CASE WHEN A.COMPRA_POR_SUPRIMENTO = 0 THEN 
								'RESSUPRIMENTO'
							WHEN A.COMPRA_POR_SUPRIMENTO = 1 THEN 
								'SUPRIMENTO'
							WHEN A.COMPRA_POR_SUPRIMENTO = 2 THEN 
								 'SUP-RESSUP' END AS TIPO, 
					F.NM_FABRIC, 
					LINHA.DS_ARV_MERC_LINHA, 
					SIGLA.DS_SIGLA,
					LINHA.CD_ARV_MERC_LINHA, 
					SIGLA.CD_SIGLA,
					A.MEDIAF,
					A2.QT_EST + A2.QT_EST_EM_TERC EST_MTZ,
					A2.QT_PEND_ENT QT_PEND_MTZ,
					A.QT_PEND_ENT QT_PEND_LJ,
					ROUND((A.MEDIAF/ 30.0) * A.EMAX ,0) EMAX,
					CASE WHEN A.QTDE_LIMITADOR > 0  THEN
						CASE WHEN A.QTDE_LIMITADOR < A.QTDE_FACEAMENTO OR
							A.QTDE_LIMITADOR < A.QTDE_FINANCIADO OR
										(ROUND((A.MEDIAF/ 30.0) * A.EMAX ,0)) < A.QTDE_LIMITADOR THEN
								A.QTDE_LIMITADOR - (A.QT_EST + A.QT_EST_EM_TERC)
						WHEN (ROUND((A.MEDIAF/ 30.0) * A.EMAX ,0)) > A.QTDE_FACEAMENTO AND (ROUND((A.MEDIAF/ 30.0) * A.EMAX ,0)) > A.QTDE_FACEAMENTO THEN
							(ROUND((A.MEDIAF/ 30.0) * A.EMAX ,0))
						WHEN A.QTDE_FACEAMENTO > (ROUND((A.MEDIAF/ 30.0) * A.EMAX ,0)) AND A.QTDE_FACEAMENTO > A.QTDE_FINANCIADO THEN
							A.QTDE_FACEAMENTO - (A.QT_EST + A.QT_EST_EM_TERC)
						WHEN A.QTDE_FINANCIADO > (ROUND((A.MEDIAF/ 30.0) * A.EMAX ,0)) AND A.QTDE_FINANCIADO > A.QTDE_FACEAMENTO THEN
							A.QTDE_FINANCIADO - (A.QT_EST + A.QT_EST_EM_TERC)
						END
					ELSE
						CASE WHEN (ROUND((A.MEDIAF/ 30.0) * A.EMAX ,0)) > A.QTDE_FACEAMENTO AND (ROUND((A.MEDIAF/ 30.0) * A.EMAX ,0)) > A.QTDE_FACEAMENTO THEN
							(ROUND((A.MEDIAF/ 30.0) * A.EMAX ,0)) - (A.QT_EST + A.QT_EST_EM_TERC)
						WHEN A.QTDE_FACEAMENTO > (ROUND((A.MEDIAF/ 30.0) * A.EMAX ,0)) AND A.QTDE_FACEAMENTO > A.QTDE_FINANCIADO THEN
							A.QTDE_FACEAMENTO - (A.QT_EST + A.QT_EST_EM_TERC)
						WHEN A.QTDE_FINANCIADO > (ROUND((A.MEDIAF/ 30.0) * A.EMAX ,0)) AND A.QTDE_FINANCIADO > A.QTDE_FACEAMENTO THEN
							A.QTDE_FINANCIADO - (A.QT_EST + A.QT_EST_EM_TERC)
						ELSE
							0
						END
					END AS NECESSIDADE

				FROM   
					EST_PROD_CPL_ANALISE_DIARIO A
					INNER JOIN  EST_PROD P ON
					A.CD_EMP  = P.CD_EMP AND 
					A.CD_PROD = P.CD_PROD    
					
					INNER JOIN  EST_PROD_FABRIC F  ON 
					A.CD_FABRIC = F.CD_FABRIC 
					
					INNER JOIN EST_PROD_CPL_ANALISE_DIARIO A2 ON 
					A.CD_EMP  = A2.CD_EMP AND 
					A.CD_PROD = A2.CD_PROD     
					
					INNER JOIN  EST_ARV_MERC_LINHA LINHA ON 
					A.CD_EMP		    = LINHA.CD_EMP AND 
					A.CD_ARV_MERC_LINHA = LINHA.CD_ARV_MERC_LINHA
					 
					INNER JOIN   EST_PROD_CURVA_SIGLA SIGLA ON 
					A.CD_EMP  = SIGLA.CD_EMP AND
					A.CD_SIGLA = SIGLA.CD_SIGLA 
				WHERE 
					A.CD_EMP = @CD_EMP
					AND A.CD_FILIAL =@CD_FILIAL  
					AND A2.CD_FILIAL = @CD_FILIAL_DEPO
					AND A.DT_VD = @DT_INI
					AND A2.DT_VD = @DT_INI
					AND A.FLAG_ANALISE_FALTAS = 0
					AND A.STS_PROD_EMP = 0
					AND A.STS_PROD_FILIAL = 0) CPL ON	 
	VD_PROD.CD_PROD		= CPL.CD_PROD AND
	VD_PROD.CD_FILIAL	= CPL.CD_FILIAL
	
	INNER JOIN (SELECT 
					CD_PROD,
					SUM(QT_EXCESSO) EXCESSO
				FROM 
					EST_PROD_CPL_ANALISE_DIARIO
				WHERE
					DT_VD = @DT_INI
					AND CD_EMP = @CD_EMP
					AND CD_FILIAL =@CD_FILIAL	
				GROUP BY
					CD_PROD) E ON
	VD_PROD.CD_PROD = E.CD_PROD 
	INNER JOIN 	PRC_FILIAL_GRP_EST_PED_ELETR_ENVIO_CPL grplj ON
	CPL.CD_FILIAL  = grplj.CD_FILIAL 
Where 
	VD_PROD.PART_QTDE > 0 
	AND VD_PROD.DT_VD = @DT_INI;
GO


